# GweCode Admin Dashboard

## Overview
This is the secure administrative control panel for managing the GweCode platform. This directory contains all files needed to manage client domains, monitor verifications, and control platform access.

## Installation Instructions

### Step 1: Upload Files
Upload all files from this directory to your server at `/var/www/gwecode.com/admin/` (or your equivalent web root path + /admin/).

### Step 2: Set Up Authentication
The admin dashboard is protected by HTTP Basic Authentication. You must create the password file before the dashboard will be accessible.

SSH into your server and run:
```bash
cd /var/www/gwecode.com/admin/
htpasswd -c .htpasswd admin
```

You will be prompted to enter and confirm a password. Choose a strong password and remember it - this is your admin login credential.

### Step 3: Update .htaccess Path
Edit the .htaccess file and update this line to match your actual server path:
```
AuthUserFile /var/www/gwecode.com/admin/.htpasswd
```

Replace `/var/www/gwecode.com/` with your actual web root directory path.

### Step 4: Set Permissions
Ensure proper file permissions are set:
```bash
chmod 644 .htpasswd
chmod 644 .htaccess
chmod 644 *.php
chmod 755 .
```

### Step 5: Test Access
Visit https://gwecode.com/admin/ in your browser. You should be prompted for authentication with username `admin` and the password you created in Step 2.

## Security Features

The admin dashboard implements multiple layers of security including HTTP Basic Authentication via .htaccess, session-based access control after authentication, protection of database files from direct HTTP access, and denial of access to configuration files. All administrative functions require proper authentication and the dashboard should only be accessed over HTTPS to ensure credential security.

## First-Time Use

After successfully logging in for the first time, the database will be created automatically. You can then add your first domain to begin managing client access to the GweCode platform.

## Troubleshooting

If you receive a 500 Internal Server Error when accessing the admin dashboard, verify that the AuthUserFile path in .htaccess matches your actual server directory structure. If you receive authentication prompts repeatedly without being able to log in, confirm that the .htpasswd file was created successfully and has the correct permissions. If the page loads but shows PHP errors, ensure that SQLite support is enabled in your PHP installation.

## Changing Admin Password

To change the admin password at any time, run the htpasswd command again. This will overwrite the existing password with a new one while preserving the username.

## Database Backup

The GweCode platform database is stored as `gwecode.db` in this directory. You should regularly back up this file to prevent data loss. The database contains all domain registrations, verification history, and platform configuration.
