<?php

class Database {
    private $db;
    
    public function __construct() {
        $this->db = new SQLite3('gwecode.db');
        $this->initialize();
    }
    
    private function initialize() {
        $this->db->exec('
            CREATE TABLE IF NOT EXISTS api_keys (
                id INTEGER PRIMARY KEY AUTOINCREMENT,
                domain TEXT NOT NULL UNIQUE,
                api_key TEXT NOT NULL UNIQUE,
                created_at TEXT NOT NULL,
                status TEXT DEFAULT "awaiting_activation",
                last_verified TEXT,
                verification_count INTEGER DEFAULT 0
            )
        ');
        
        $this->db->exec('
            CREATE TABLE IF NOT EXISTS clients (
                id INTEGER PRIMARY KEY AUTOINCREMENT,
                api_key_id INTEGER NOT NULL,
                site_name TEXT,
                settings TEXT DEFAULT "{}",
                last_active TEXT,
                FOREIGN KEY (api_key_id) REFERENCES api_keys(id)
            )
        ');
    }
    
    public function getConnection() {
        return $this->db;
    }
}

?>
