<?php

session_start();

header('Content-Type: application/json');

require_once 'database.php';

$database = new Database();
$db = $database->getConnection();

$action = $_GET['action'] ?? '';

function matchesDomain($pattern, $domain) {
    if ($pattern === $domain) {
        return true;
    }
    
    if (strpos($pattern, '*.') === 0) {
        $baseDomain = substr($pattern, 2);
        
        if ($domain === $baseDomain) {
            return false;
        }
        
        if (substr($domain, -strlen('.' . $baseDomain)) === '.' . $baseDomain) {
            return true;
        }
    }
    
    return false;
}

if ($action === 'create') {
    $input = json_decode(file_get_contents('php://input'), true);
    $domain = $input['domain'] ?? '';
    
    if (empty($domain)) {
        http_response_code(400);
        echo json_encode(['error' => 'Domain is required']);
        exit;
    }
    
    if (strpos($domain, '*.') === 0) {
        $baseDomain = substr($domain, 2);
        if (!preg_match('/^(?:[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?\.)+[a-z0-9][a-z0-9-]{0,61}[a-z0-9]$/i', $baseDomain)) {
            http_response_code(400);
            echo json_encode(['error' => 'Invalid wildcard domain format']);
            exit;
        }
    } else {
        if (!preg_match('/^(?:[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?\.)+[a-z0-9][a-z0-9-]{0,61}[a-z0-9]$/i', $domain)) {
            http_response_code(400);
            echo json_encode(['error' => 'Invalid domain format']);
            exit;
        }
    }
    
    $stmt = $db->prepare('SELECT id FROM api_keys WHERE domain = :domain');
    $stmt->bindValue(':domain', $domain, SQLITE3_TEXT);
    $result = $stmt->execute();
    
    if ($result->fetchArray()) {
        http_response_code(409);
        echo json_encode(['error' => 'This domain pattern already exists in the system']);
        exit;
    }
    
    $apiKey = bin2hex(random_bytes(32));
    $hashedKey = hash('sha256', $apiKey);
    $createdAt = date('Y-m-d H:i:s');
    
    $stmt = $db->prepare('INSERT INTO api_keys (domain, api_key, created_at, status) VALUES (:domain, :api_key, :created_at, "awaiting_activation")');
    $stmt->bindValue(':domain', $domain, SQLITE3_TEXT);
    $stmt->bindValue(':api_key', $hashedKey, SQLITE3_TEXT);
    $stmt->bindValue(':created_at', $createdAt, SQLITE3_TEXT);
    $stmt->execute();
    
    $keyId = $db->lastInsertRowID();
    
    $stmt = $db->prepare('INSERT INTO clients (api_key_id, settings) VALUES (:api_key_id, "{}")');
    $stmt->bindValue(':api_key_id', $keyId, SQLITE3_INTEGER);
    $stmt->execute();
    
    echo json_encode([
        'success' => true,
        'domain' => $domain,
        'message' => 'Domain added successfully'
    ]);
    
} elseif ($action === 'keys') {
    $result = $db->query('
        SELECT 
            ak.id,
            ak.domain,
            ak.created_at,
            ak.status,
            ak.last_verified,
            ak.verification_count,
            c.site_name,
            c.last_active
        FROM api_keys ak
        LEFT JOIN clients c ON c.api_key_id = ak.id
        ORDER BY ak.created_at DESC
    ');
    
    $keys = [];
    while ($row = $result->fetchArray(SQLITE3_ASSOC)) {
        $keys[] = $row;
    }
    
    echo json_encode(['success' => true, 'keys' => $keys]);
    
} elseif ($action === 'toggle') {
    $input = json_decode(file_get_contents('php://input'), true);
    $id = $input['id'] ?? 0;
    
    if (empty($id)) {
        http_response_code(400);
        echo json_encode(['error' => 'ID is required']);
        exit;
    }
    
    $stmt = $db->prepare('SELECT status FROM api_keys WHERE id = :id');
    $stmt->bindValue(':id', $id, SQLITE3_INTEGER);
    $result = $stmt->execute();
    $row = $result->fetchArray(SQLITE3_ASSOC);
    
    if (!$row) {
        http_response_code(404);
        echo json_encode(['error' => 'Domain not found']);
        exit;
    }
    
    $newStatus = ($row['status'] === 'active') ? 'inactive' : 'active';
    
    $stmt = $db->prepare('UPDATE api_keys SET status = :status WHERE id = :id');
    $stmt->bindValue(':status', $newStatus, SQLITE3_TEXT);
    $stmt->bindValue(':id', $id, SQLITE3_INTEGER);
    $stmt->execute();
    
    echo json_encode([
        'success' => true,
        'status' => $newStatus,
        'message' => 'Status updated successfully'
    ]);
    
} else {
    http_response_code(404);
    echo json_encode(['error' => 'Invalid action']);
}

?>
