# GWECODE API Endpoint

## Overview
This package contains the public-facing API endpoint that handles client domain verification requests. Client websites connect to this endpoint to verify their registration status with GWECODE.

## Installation
Upload the api.php file to your web root directory at gwecode.com. The file should be accessible at https://gwecode.com/api.php for the client SDK to function correctly.

## Requirements
This API endpoint requires that the GWECODE admin dashboard be deployed first, as it depends on the database connection file located in the admin directory. Ensure the admin package is fully installed and configured before deploying this API endpoint.

## How It Works
Client websites make POST requests to this endpoint with their domain information. The API checks the GWECODE database to verify if the domain is registered and determines its current status. For registered domains, the API updates verification timestamps and counts, tracking client activity. Domains in awaiting_activation status are automatically promoted to active upon first successful verification.

## Security Considerations
The API implements domain-based verification preventing unauthorized access to GWECODE services. CORS headers are configured to allow cross-origin requests from client websites. All verification requests are validated and sanitized before database operations. Domain matching supports both exact matches and wildcard subdomain patterns.

## Testing the API
After deployment, you can test the endpoint by making a POST request to https://gwecode.com/api.php?action=verify with a JSON body containing a registered domain. A successful response indicates the API is functioning correctly and can communicate with the GWECODE database.

## Troubleshooting
If the API returns errors about database connection failures, verify that the admin dashboard is properly installed and the database has been created. If client verifications fail, ensure that SSL is properly configured for gwecode.com as the client SDK requires HTTPS connections. Review server error logs for detailed PHP error messages if verification requests produce unexpected results.
