<?php

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once __DIR__ . '/admin/database.php';

$database = new Database();
$db = $database->getConnection();

$action = $_GET['action'] ?? '';

function matchesDomain($pattern, $domain) {
    if ($pattern === $domain) {
        return true;
    }
    
    if (strpos($pattern, '*.') === 0) {
        $baseDomain = substr($pattern, 2);
        
        if ($domain === $baseDomain) {
            return false;
        }
        
        if (substr($domain, -strlen('.' . $baseDomain)) === '.' . $baseDomain) {
            return true;
        }
    }
    
    return false;
}

if ($action === 'verify') {
    $input = json_decode(file_get_contents('php://input'), true);
    $domain = $input['domain'] ?? '';
    
    if (empty($domain)) {
        http_response_code(400);
        echo json_encode(['error' => 'Domain is required']);
        exit;
    }
    
    $result = $db->query('
        SELECT 
            ak.id,
            ak.domain,
            ak.status,
            c.settings
        FROM api_keys ak
        LEFT JOIN clients c ON c.api_key_id = ak.id
    ');
    
    $matchedRow = null;
    while ($row = $result->fetchArray(SQLITE3_ASSOC)) {
        if (matchesDomain($row['domain'], $domain)) {
            $matchedRow = $row;
            break;
        }
    }
    
    if (!$matchedRow) {
        http_response_code(401);
        echo json_encode(['error' => 'Domain not registered']);
        exit;
    }
    
    $currentTime = date('Y-m-d H:i:s');
    
    $stmt = $db->prepare('UPDATE api_keys SET last_verified = :last_verified, verification_count = verification_count + 1 WHERE id = :id');
    $stmt->bindValue(':last_verified', $currentTime, SQLITE3_TEXT);
    $stmt->bindValue(':id', $matchedRow['id'], SQLITE3_INTEGER);
    $stmt->execute();
    
    if ($matchedRow['status'] === 'awaiting_activation') {
        $stmt = $db->prepare('UPDATE api_keys SET status = "active" WHERE id = :id');
        $stmt->bindValue(':id', $matchedRow['id'], SQLITE3_INTEGER);
        $stmt->execute();
        $matchedRow['status'] = 'active';
    }
    
    $stmt = $db->prepare('UPDATE clients SET last_active = :last_active WHERE api_key_id = :api_key_id');
    $stmt->bindValue(':last_active', $currentTime, SQLITE3_TEXT);
    $stmt->bindValue(':api_key_id', $matchedRow['id'], SQLITE3_INTEGER);
    $stmt->execute();
    
    if ($matchedRow['status'] !== 'active') {
        http_response_code(403);
        echo json_encode([
            'error' => 'Domain is inactive',
            'verified' => false,
            'status' => $matchedRow['status'],
            'matched_pattern' => $matchedRow['domain']
        ]);
        exit;
    }
    
    echo json_encode([
        'success' => true,
        'verified' => true,
        'status' => $matchedRow['status'],
        'matched_pattern' => $matchedRow['domain'],
        'settings' => json_decode($matchedRow['settings'] ?: '{}')
    ]);
    
} else {
    http_response_code(404);
    echo json_encode(['error' => 'Invalid action']);
}

?>
